uniform sampler2D texLeft;
uniform sampler2D texRight;
uniform sampler2D texCloud;

uniform float crossfader;
uniform float randomSeed;
uniform float levelLeft;
uniform float levelRight;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
  vec4 color = gl_Color;
  
  float noise = texture2D(texCloud, fract(uv.xy + randomSeed)).x; 
	if (noise > crossfader)
  {
		color = texture2D(texLeft, uv.xy);
    color.a = levelLeft;
  }
  else 
  {
    color = texture2D(texRight, uv.xy);
    color.a = levelRight;
  }
  gl_FragColor = color;
}
